<?php
// routes/api.php

use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\AdminController;
use App\Controllers\CustomerController;
use App\Controllers\TaskController;
use App\Controllers\NoteController;

// Auth Routes (Public)
Router::post('/api/login', [AuthController::class, 'login']);

// Protected Routes (Require Authentication)
Router::get('/api/me', [AuthController::class, 'me']);
Router::put('/api/profile', [AuthController::class, 'updateProfile']);
Router::post('/api/logout', [AuthController::class, 'logout']);

// Admin Routes
Router::get('/api/admin/dashboard', [AdminController::class, 'dashboard']);
Router::get('/api/admin/users', [AdminController::class, 'getUsers']);
Router::post('/api/admin/users', [AdminController::class, 'createUser']);
Router::put('/api/admin/users/{id}', [AdminController::class, 'updateUser']);
Router::delete('/api/admin/users/{id}', [AdminController::class, 'deleteUser']);
Router::get('/api/admin/logs', [AdminController::class, 'getLogs']);

// Customer Routes
Router::get('/api/customers', [CustomerController::class, 'index']);
Router::get('/api/customers/{id}', [CustomerController::class, 'show']);
Router::post('/api/customers', [CustomerController::class, 'create']);
Router::put('/api/customers/{id}', [CustomerController::class, 'update']);
Router::delete('/api/customers/{id}', [CustomerController::class, 'delete']);
Router::get('/api/customers/search', [CustomerController::class, 'search']);

// Task Routes
Router::get('/api/tasks', [TaskController::class, 'index']);
Router::get('/api/tasks/{id}', [TaskController::class, 'show']);
Router::post('/api/tasks', [TaskController::class, 'create']);
Router::put('/api/tasks/{id}', [TaskController::class, 'update']);
Router::delete('/api/tasks/{id}', [TaskController::class, 'delete']);
Router::get('/api/tasks/stats', [TaskController::class, 'stats']);

// Note Routes
Router::get('/api/customers/{id}/notes', [NoteController::class, 'index']);
Router::post('/api/customers/{id}/notes', [NoteController::class, 'create']);
Router::delete('/api/notes/{id}', [NoteController::class, 'delete']);