<?php
// public/index.php

// Hata raporlama (production'da kapatın)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Zaman dilimi
date_default_timezone_set('Europe/Istanbul');

// CORS Headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Max-Age: 86400');

// OPTIONS request için erken dönüş (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Autoloader
spl_autoload_register(function ($class) {
    // App namespace'ini dosya yoluna çevir
    $prefix = 'App\\';
    $baseDir = __DIR__ . '/../app/';
    
    // Sınıf App namespace'inde mi kontrol et
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    // Namespace'den dosya yolunu oluştur
    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    
    // Dosya varsa dahil et
    if (file_exists($file)) {
        require $file;
    }
});

// Config dosyasını yükle
$configFile = __DIR__ . '/../config.php';
if (!file_exists($configFile)) {
    die(json_encode([
        'success' => false,
        'message' => 'config.php dosyası bulunamadı!'
    ]));
}

// ==========================================
// ÖNEMLİ: Route tanımlamalarını dahil et!
// ==========================================
require_once __DIR__ . '/../routes/api.php';

// Router'ı çalıştır
use App\Core\Router;
Router::dispatch();