<?php
// app/Models/Customer.php

namespace App\Models;

use App\Core\Database;

class Customer {
    private $db;
    private $table = 'customers';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function findAll() {
        $sql = "SELECT c.*, u.ad_soyad as kullanici_adi 
                FROM {$this->table} c 
                LEFT JOIN users u ON c.kullanici_id = u.id 
                ORDER BY c.id DESC";
        return $this->db->fetchAll($sql);
    }

    public function findById($id) {
        $sql = "SELECT c.*, u.ad_soyad as kullanici_adi 
                FROM {$this->table} c 
                LEFT JOIN users u ON c.kullanici_id = u.id 
                WHERE c.id = :id";
        return $this->db->fetch($sql, ['id' => $id]);
    }

    public function findByUser($userId) {
        $sql = "SELECT * FROM {$this->table} WHERE kullanici_id = :user_id ORDER BY id DESC";
        return $this->db->fetchAll($sql, ['user_id' => $userId]);
    }

    public function create($data) {
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, 'id = :id', ['id' => $id]);
    }

    public function delete($id) {
        return $this->db->delete($this->table, 'id = :id', ['id' => $id]);
    }

    public function count() {
        $sql = "SELECT COUNT(*) as total FROM {$this->table}";
        $result = $this->db->fetch($sql);
        return $result['total'] ?? 0;
    }

    public function countByUser($userId) {
        $sql = "SELECT COUNT(*) as total FROM {$this->table} WHERE kullanici_id = :user_id";
        $result = $this->db->fetch($sql, ['user_id' => $userId]);
        return $result['total'] ?? 0;
    }

    public function search($term, $userId = null) {
        $sql = "SELECT c.*, u.ad_soyad as kullanici_adi 
                FROM {$this->table} c 
                LEFT JOIN users u ON c.kullanici_id = u.id 
                WHERE (c.ad_soyad LIKE :term OR c.sirket_adi LIKE :term OR c.email LIKE :term)";
        
        $params = ['term' => "%$term%"];
        
        if ($userId) {
            $sql .= " AND c.kullanici_id = :user_id";
            $params['user_id'] = $userId;
        }
        
        $sql .= " ORDER BY c.id DESC";
        
        return $this->db->fetchAll($sql, $params);
    }
}