<?php
// app/Core/Router.php

namespace App\Core;

class Router {
    private static $routes = [];
    private static $middleware = [];

    public static function get($path, $handler) {
        self::addRoute('GET', $path, $handler);
    }

    public static function post($path, $handler) {
        self::addRoute('POST', $path, $handler);
    }

    public static function put($path, $handler) {
        self::addRoute('PUT', $path, $handler);
    }

    public static function delete($path, $handler) {
        self::addRoute('DELETE', $path, $handler);
    }

    public static function middleware($name, $callable) {
        self::$middleware[$name] = $callable;
    }

    private static function addRoute($method, $path, $handler) {
        self::$routes[] = [
            'method' => $method,
            'path' => $path,
            'handler' => $handler,
            'middleware' => []
        ];
    }

    public static function group($options, $callback) {
        $previousMiddleware = self::$middleware;
        
        if (isset($options['middleware'])) {
            foreach ($options['middleware'] as $m) {
                self::$middleware[$m] = true;
            }
        }

        $callback();

        self::$middleware = $previousMiddleware;
    }

    public static function dispatch() {
        $method = $_SERVER['REQUEST_METHOD'];
        $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $path = rtrim($path, '/') ?: '/';

        foreach (self::$routes as $route) {
            if ($route['method'] !== $method) {
                continue;
            }

            $pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([a-zA-Z0-9_]+)', $route['path']);
            $pattern = '#^' . $pattern . '$#';

            if (preg_match($pattern, $path, $matches)) {
                array_shift($matches);
                
                $handler = $route['handler'];
                
                if (is_array($handler)) {
                    [$controller, $methodName] = $handler;
                    $controllerInstance = new $controller();
                    call_user_func_array([$controllerInstance, $methodName], $matches);
                } else {
                    call_user_func_array($handler, $matches);
                }
                return;
            }
        }

        Response::notFound('Sayfa bulunamadı');
    }
}