<?php
// app/Core/Response.php

namespace App\Core;

class Response {
    public static function json($data, $status = 200) {
        http_response_code($status);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }

    public static function success($message = 'İşlem başarılı', $data = null, $status = 200) {
        self::json([
            'success' => true,
            'message' => $message,
            'data' => $data
        ], $status);
    }

    public static function error($message = 'Bir hata oluştu', $errors = null, $status = 400) {
        self::json([
            'success' => false,
            'message' => $message,
            'errors' => $errors
        ], $status);
    }

    public static function unauthorized($message = 'Yetkilendirme hatası') {
        self::error($message, null, 401);
    }

    public static function forbidden($message = 'Bu işlem için yetkiniz yok') {
        self::error($message, null, 403);
    }

    public static function notFound($message = 'Kayıt bulunamadı') {
        self::error($message, null, 404);
    }

    public static function redirect($url) {
        header("Location: $url");
        exit;
    }
}