<?php
// app/Core/Request.php

namespace App\Core;

class Request {
    private $data;
    private $method;
    private $headers;

    public function __construct() {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->headers = getallheaders() ?: [];
        
        $contentType = $_SERVER['CONTENT_TYPE'] ?? '';
        
        if (strpos($contentType, 'application/json') !== false) {
            $this->data = json_decode(file_get_contents('php://input'), true) ?? [];
        } else {
            $this->data = array_merge($_GET, $_POST);
        }
    }

    public function get($key = null, $default = null) {
        if ($key === null) {
            return $this->data;
        }
        return $this->data[$key] ?? $default;
    }

    public function method() {
        return $this->method;
    }

    public function header($key, $default = null) {
        return $this->headers[$key] ?? $default;
    }

    public function bearerToken() {
        $auth = $this->header('Authorization', '');
        if (strpos($auth, 'Bearer ') === 0) {
            return substr($auth, 7);
        }
        return null;
    }

    public function input($key, $default = null) {
        return $this->get($key, $default);
    }

    public function all() {
        return $this->data;
    }

    public function has($key) {
        return isset($this->data[$key]);
    }

    public function ip() {
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }

    public function validate($rules) {
        $errors = [];
        
        foreach ($rules as $field => $ruleSet) {
            $ruleArray = explode('|', $ruleSet);
            $value = $this->get($field);
            
            foreach ($ruleArray as $rule) {
                if ($rule === 'required' && empty($value)) {
                    $errors[$field][] = "$field alanı zorunludur.";
                }
                
                if (strpos($rule, 'min:') === 0) {
                    $min = (int)substr($rule, 4);
                    if (strlen($value) < $min) {
                        $errors[$field][] = "$field en az $min karakter olmalıdır.";
                    }
                }
                
                if (strpos($rule, 'max:') === 0) {
                    $max = (int)substr($rule, 4);
                    if (strlen($value) > $max) {
                        $errors[$field][] = "$field en fazla $max karakter olmalıdır.";
                    }
                }
                
                if ($rule === 'email' && !empty($value) && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                    $errors[$field][] = "$field geçerli bir e-posta adresi olmalıdır.";
                }
            }
        }
        
        return empty($errors) ? true : $errors;
    }
}